/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.handlers.slack;

import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.action.handlers.slack.SlackAccount;
import com.floragunn.signals.watch.action.handlers.slack.SlackActionConf;
import com.floragunn.signals.watch.common.HttpClient;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpUtils;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.io.IOException;
import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SlackAction
extends ActionHandler {
    public static final String TYPE = "slack";
    private final SlackActionConf slackActionConf;
    private TemplateScript.Factory fromScript;
    private TemplateScript.Factory textScript;
    private TemplateScript.Factory iconScript;
    private TemplateScript.Factory channelScript;
    private TemplateScript.Factory blocksScript;
    private TemplateScript.Factory attachmentScript;

    public SlackAction(SlackActionConf slackActionConf) {
        this.slackActionConf = slackActionConf;
    }

    public void compileScripts(WatchInitializationService watchInitService) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        this.fromScript = watchInitService.compileTemplate("from", this.slackActionConf.getFrom(), validationErrors);
        this.textScript = watchInitService.compileTemplate("text", this.slackActionConf.getText(), validationErrors);
        this.iconScript = watchInitService.compileTemplate("icon", this.slackActionConf.getIconEmoji(), validationErrors);
        this.channelScript = watchInitService.compileTemplate("channel", this.slackActionConf.getChannel(), validationErrors);
        if (this.slackActionConf.getBlocks() != null) {
            this.blocksScript = watchInitService.compileTemplate("blocks", DocWriter.json().writeAsString(this.slackActionConf.getBlocks()), validationErrors);
        }
        if (this.slackActionConf.getAttachments() != null) {
            this.attachmentScript = watchInitService.compileTemplate("attachments", DocWriter.json().writeAsString(this.slackActionConf.getAttachments()), validationErrors);
        }
        if (this.textScript == null && this.blocksScript == null && this.attachmentScript == null) {
            validationErrors.add((ValidationError)new MissingAttribute("text", (Object)this.slackActionConf.toJsonString()));
        }
        validationErrors.throwExceptionForPresentErrors();
    }

    @Override
    public ActionExecutionResult execute(WatchExecutionContext ctx) throws ActionExecutionException {
        try {
            SlackAccount destination = ctx.getAccountRegistry().lookupAccount(this.slackActionConf.getAccount(), SlackAccount.class);
            HttpClientConfig httpClientConfig = new HttpClientConfig(null, null, null, null);
            HttpUriRequest httpRequest = this.createSlackRequest(ctx, destination);
            if (ctx.getSimulationMode() == SimulationMode.FOR_REAL) {
                try (HttpClient httpClient = httpClientConfig.createHttpClient(ctx.getHttpProxyConfig());){
                    CloseableHttpResponse response = AccessController.doPrivileged(() -> httpClient.execute(httpRequest));
                    if (response.getStatusLine().getStatusCode() >= 400) {
                        throw new ActionExecutionException((ActionHandler)this, "Slack web hook returned error: " + response.getStatusLine() + "\n" + HttpUtils.getEntityAsDebugString((HttpResponse)response));
                    }
                    if (response.getStatusLine().getStatusCode() >= 300) {
                        throw new ActionExecutionException((ActionHandler)this, "Slack web hook returned unexpected response: " + response.getStatusLine() + "\n" + HttpUtils.getEntityAsDebugString((HttpResponse)response));
                    }
                }
            }
            return new ActionExecutionResult(HttpUtils.getRequestAsDebugString(httpRequest));
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionExecutionException((ActionHandler)this, "Error while sending slack message: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private HttpUriRequest createSlackRequest(WatchExecutionContext ctx, SlackAccount slackDestination) {
        HttpPost result = new HttpPost(slackDestination.getUrl());
        result.setEntity((HttpEntity)new StringEntity(this.createSlackRequestBody(ctx), ContentType.APPLICATION_JSON));
        return result;
    }

    private String createSlackRequestBody(WatchExecutionContext ctx) {
        String text = this.render(ctx, this.textScript);
        String username = this.render(ctx, this.fromScript);
        String icon = this.render(ctx, this.iconScript);
        String channel = this.render(ctx, this.channelScript);
        String blocks = this.render(ctx, this.blocksScript);
        String attachments = this.render(ctx, this.attachmentScript);
        LinkedHashMap<String, String> document = new LinkedHashMap<String, String>();
        if (channel != null) {
            document.put("channel", channel);
        }
        if (username != null) {
            document.put("username", username);
        }
        if (text != null) {
            document.put("text", text);
        }
        if (blocks != null) {
            document.put("blocks", blocks);
        }
        if (attachments != null) {
            document.put("attachments", attachments);
        }
        if (icon != null) {
            document.put("icon_emoji", icon);
        }
        return DocWriter.json().writeAsString(document);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map slackActionConfMap = (Map)this.slackActionConf.toBasicObject();
        for (Map.Entry entry : slackActionConfMap.entrySet()) {
            if (entry.getKey() == null) continue;
            builder.field((String)entry.getKey(), entry.getValue());
        }
        return builder;
    }

    public static class Factory
    extends ActionHandler.Factory<SlackAction> {
        public Factory() {
            super(SlackAction.TYPE);
        }

        @Override
        protected SlackAction create(WatchInitializationService watchInitService, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) throws ConfigValidationException {
            SlackActionConf slackActionConf = new SlackActionConf();
            slackActionConf.setAccount(vJsonNode.get("account").asString());
            slackActionConf.setFrom(vJsonNode.get("from").asString());
            slackActionConf.setChannel(vJsonNode.get("channel").asString());
            slackActionConf.setText(vJsonNode.get("text").asString());
            if (vJsonNode.hasNonNull("blocks")) {
                slackActionConf.setBlocks(vJsonNode.getDocumentNode().getAsListOfNodes("blocks").stream().map(b -> b.toMap()).collect(Collectors.toList()));
            }
            if (vJsonNode.hasNonNull("attachments")) {
                slackActionConf.setAttachments(vJsonNode.getDocumentNode().getAsListOfNodes("attachments").stream().map(b -> b.toMap()).collect(Collectors.toList()));
            }
            slackActionConf.setIconEmoji(vJsonNode.get("icon_emoji").asString());
            if (!(vJsonNode.hasNonNull("text") || vJsonNode.hasNonNull("blocks") || vJsonNode.hasNonNull("attachments"))) {
                validationErrors.add((ValidationError)new MissingAttribute("text", (Object)vJsonNode));
            }
            validationErrors.throwExceptionForPresentErrors();
            watchInitService.verifyAccount(slackActionConf.getAccount(), SlackAccount.class, validationErrors, vJsonNode.getDocumentNode());
            SlackAction result = new SlackAction(slackActionConf);
            result.compileScripts(watchInitService);
            return result;
        }
    }
}

